﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file nsoc_stat.h
 * NSOC_GetInterfaceOpt(), NSOC_SetInterfaceOpt()で使用する各プロトコルの統計情報構造体
 */

#ifndef NN_NET_COMPATIBLE_NSOC_NSOC_STAT_H_
#define NN_NET_COMPATIBLE_NSOC_NSOC_STAT_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_INTERFACE_STATISTICS使用時の構造体
 */
typedef struct NSOCInstanceStat
{
    u64             inOctets;           /**< 受信したパケット数 */
    u32             inUcastPkts;        /**< 受信したユニキャストパケット数 */
    u32             inNUcastPkts;       /**< 受信した非ユニキャストパケット数 */
    u32             inDiscards;         /**< 破棄した受信パケット数 */
    u32             inErrors;           /**< エラーだった受信パケット数 */
    u32             inUnknownProtos;    /**< 不明なプロトコルだった受信パケット数 */
    u32             outUcastPkts;       /**< 送信したユニキャストパケット数 */
    u64             outOctets;          /**< 送信した総バイト数 */
    u32             outNUcastPkts;      /**< 送信した非ユニキャストパケット数 */
    u32             outDiscards;        /**< 破棄した送信パケット数 */
    u32             outErrors;          /**< エラーとなった送信パケット数 */
    u32             outCollisions;      /**< Ethernetでコリジョンエラーとなったパケット数 */
} NSOCInstanceStat;


/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_IP_STATISTICS使用時の構造体
 */
typedef struct NSOCIPStat
{
    u32             inReceives;         /**< 受信したIPパケット数 */
    u32             inHdrErrors;        /**< ヘッダエラーだったIPパケット数 */
    u32             inAddrErrors;       /**< IPアドレスエラーだったIPパケット数 */
    u32             inUnknownProtos;    /**< プロトコルが不明だったIPパケット数 */
    u32             inDiscards;         /**< 破棄したIPパケット数 */
    u32             inDelivers;         /**< 上位プロトコルに渡したIPパケット数 */
    u32             outRequests;        /**< 送信要求のあったIPパケット数 */
    u32             outDiscards;        /**< 破棄された送信IPパケット数 */
    u32             outNoRoutes;        /**< 到達不可だったIPパケット数 */
    u32             reasmTimeout;       /**< 再構築タイムアウトだったIPパケット数 */
    u32             reasmReqds;         /**< 受信したIPフラグメントパケット数 */
    u32             reasmOKs;           /**< 再構築に成功したIPパケット数 */
    u32             reasmFails;         /**< 再構築に失敗したIPパケット数 */
    u32             fragOKs;            /**< フラグメントに成功した送信IPパケット数 */
    u32             fragFails;          /**< フラグメントに失敗した送信IPパケット数 */
    u32             fragCreates;        /**< 作成されたIPフラグメントパケット数 */
} NSOCIPStat;

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_ICMP_STATISTICS使用時の構造体
 */
typedef struct NSOCICMPStat
{
    u32             inMsgs;             /**< 受信したICMPパケット数 */
    u32             inErrors;           /**< 受信エラーとなったICMPパケット数 */
    u32             inDestUnreachs;     /**< 受信したDestination Unreachableパケット数 */
    u32             inTimeExcds;        /**< 受信したTime Exceededパケット数 */
    u32             inParmProbs;        /**< 受信したParameter Problemパケット数 */
    u32             inSrcQuenchs;       /**< 受信したSource Quenchパケット数 */
    u32             inRedirects;        /**< 受信したRedirectパケット数 */
    u32             inEchos;            /**< 受信したEcho Requestパケット数 */
    u32             inEchoReps;         /**< 受信したEcho Responseパケット数 */
    u32             inTimestamps;       /**< 受信したTimestamp Requestパケット数 */
    u32             inTimestampReps;    /**< 受信したTimestamp Replyパケット数 */
    u32             inAddrMasks;        /**< 受信したAddress Mask Requestパケット数 */
    u32             inAddrMaskReps;     /**< 受信したAddress Mask Replyパケット数 */
    u32             outMsgs;            /**< 送信したICMPパケット数 */
    u32             outErrors;          /**< 送信エラーとなったICMPパケット数 */
    u32             outDestUnreachs;    /**< 送信したDestination Unreachableパケット数 */
    u32             outTimeExcds;       /**< 送信したTime Exceededパケット数 */
    u32             outParmProbs;       /**< 送信したParameter Problemパケット数 */
    u32             outSrcQuenchs;      /**< 送信したSource Quenchパケット数 */
    u32             outRedirects;       /**< 送信したRedirectパケット数 */
    u32             outEchos;           /**< 送信したEcho Requestパケット数 */
    u32             outEchoReps;        /**< 送信したEcho Responseパケット数 */
    u32             outTimestamps;      /**< 送信したTimestamp Requestパケット数（現在未使用） */
    u32             outTimestampReps;   /**< 送信したTimestamp Replyパケット数（現在未使用） */
    u32             outAddrMasks;       /**< 送信したAddress Mask Requestパケット数（現在未使用） */
    u32             outAddrMaskReps;    /**< 送信したAddress Mask Replyパケット数（現在未使用） */
} NSOCICMPStat;

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_UDP_STATISTICS使用時の構造体
 */
typedef struct NSOCUDPStat
{
    u32             inDatagrams;         /**< 受信したUDPパケット数 */
    u32             inErrors;            /**< 受信したエラーUDPパケット数 */
    u32             noPorts;             /**< 該当ポートがオープンされていなかった受信UDPパケット数 */
    u32             outDatagrams;        /**< 送信したUDPパケット数 */
    u32             outErrors;          /**< 送信エラーとなったUDPパケット数 */
} NSOCUDPStat;

/**
 * NSOC_GetInstanceOpt(), NSOC_SetInstanceOpt()でNSOC_CONFIG_TCP_STATISTICS使用時の構造体
 */
typedef struct NSOCTCPStat
{
    u32             activeOpens;         /**< NSOC_Connect()による接続回数 */
    u32             passiveOpens;        /**< NSOC_Accept()による着信回数 */
    u32             attemptFails;        /**< 接続失敗回数 */
    u32             estabResets;         /**< RSTによる切断回数 */
    u32             currEstab;           /**< 現在接続確立しているソケット数 */
    u32             inSegs;              /**< 受信したTCPパケット数 */
    u32             outSegs;             /**< 送信したTCPパケット数 */
    u32             retransSegs;         /**< 再送したTCPパケット数 */
    u32             inErrs;              /**< 受信したエラーTCPパケット数 */
    u32             outErrs;             /**< 送信エラーとなったTCPパケット数 */
    u32             outRsts;             /**< RST送信数 */
} NSOCTCPStat;

#ifdef NSOC_IP6_ENABLE
typedef struct NSOCIP6Stat
{
    u32             inReceives;         /**< 受信したIPv6パケット数 */
    u32             inHdrErrors;        /**< ヘッダエラーだった受信IPv6パケット数 */
    u32             inAddrErrors;       /**< IPアドレスエラーだった受信IPv6パケット数 */
    u32             inUnknownProtos;    /**< プロトコルが不明だった受信IPv6パケット数 */
    u32             inTruncatedPkts;    /**< 長さ不足の受信IPv6パケット数 */
    u32             inDiscards;         /**< IP層で破棄した受信IPv6パケット数 */
    u32             inDelivers;         /**< 上位プロトコルに渡したIPv6パケット数 */
    u32             outRequests;        /**< 送信要求のあったIPv6パケット数 */
    u32             outDiscards;        /**< IP層で破棄した送信IPv6パケット数 */
    u32             outFragOKs;         /**< フラグメントに成功した送信IPv6パケット数 */
    u32             outFragFails;       /**< フラグメントに失敗した送信IPv6パケット数 */
    u32             outFragCreates;     /**< 作成されたIPv6フラグメントパケット数 */
    u32             reasmReqds;         /**< 受信したIPv6フラグメントパケット数 */
    u32             reasmOKs;           /**< 再構築に成功したIPv6パケット数 */
    u32             reasmFails;         /**< 再構築に失敗したIPv6パケット数 */
    u32             inMcastPkts;        /**< 受信したIPv6マルチキャストパケット数 */
    u32             outMcastPkts;       /**< 送信したIPv6マルチキャストパケット数 */
} NSOCIP6Stat;

typedef struct NSOCICMP6Stat
{
    u32             inMsgs;             /**< 受信したICMPv6パケット数 */
    u32             inErrors;           /**< 受信エラーとなったICMPv6パケット数 */
    u32             inDestUnreachs;     /**< 受信したDestination Unreachableエラーパケット数 */
    u32             inAdminProhibs;     /**< 受信したadministratively prohibitedエラーパケット数 */
    u32             inTimeExcds;        /**< 受信したTime Exceededエラーパケット数 */
    u32             inParmProblems;     /**< 受信したParameter Problemエラーパケット数 */
    u32             inPktTooBigs;       /**< 受信したPacket Too Bigエラーパケット数 */
    u32             inEchos;            /**< 受信したEcho Requestパケット数 */
    u32             inEchoReplies;      /**< 受信したEcho Replyパケット数 */
    u32             inRouterSolicits;   /**< 受信したRouter Solicitパケット数 */
    u32             inRouterAdvertisements; /**< 受信したRouter Advertisementパケット数 */
    u32             inNeighborSolicits; /**< 受信したNeighbor Solicitパケット数 */
    u32             inNeighborAdvertisements; /**< 受信したNeighbor Advertisementパケット数 */
    u32             inRedirects;        /**< 受信したRedirectパケット数 */
    u32             inGroupMembQueries; /**< 受信したMLD Listener Queryパケット数 */
    u32             inGroupMembResponses; /**< 受信したMLD Listener Reportパケット数 */
    u32             inGroupMembResponsesV1; /**< 受信したMLD Listener Report V1パケット数 */
    u32             inGroupMembReductions; /**< 受信したMLD Listener Reductionパケット数 */
    u32             outMsgs;            /**< 送信したICMPv6パケット数 */
    u32             outErrors;          /**< 送信エラーとなったICMPv6パケット数 */
    u32             outDestUnreachs;    /**< 送信したDestination Unreachableパケット数 */
    u32             outAdminProhibs;    /**< 送信したadministratively prohibitedエラーパケット数 */
    u32             outTimeExcds;       /**< 送信したTime Exceededエラーパケット数 */
    u32             outParmProblems;    /**< 送信したParameter Problemエラーパケット数 */
    u32             outPktTooBigs;      /**< 送信したPacket Too Bigエラーパケット数 */
    u32             outEchos;           /**< 送信したEcho Requestパケット数 */
    u32             outEchoReplies;     /**< 送信したEcho Replyパケット数 */
    u32             outRouterSolicits;  /**< 送信したRouter Solicitパケット数 */
    u32             outRouterAdvertisements; /**< 送信したRouter Advertisementパケット数 */
    u32             outNeighborSolicits; /**< 送信したNeighbor Solicitパケット数 */
    u32             outNeighborAdvertisements; /**< 送信したNeighbor Advertisementパケット数 */
    u32             outRedirects;       /**< 送信したRedirectパケット数 */
    u32             outGroupMembQueries; /**< 送信したMLD Listener Queryパケット数 */
    u32             outGroupMembResponses; /**< 送信したMLD Listener Reportパケット数 */
    u32             outGroupMembResponsesV1; /**< 送信したMLD Listener Report V1パケット数 */
    u32             outGroupMembReductions; /**< 送信したMLD Listener Reductionパケット数 */
} NSOCICMP6Stat;
#endif

#ifdef __cplusplus
}
#endif

#endif  /* NN_NET_COMPATIBLE_NSOC_NSOC_STAT_H_ */
