﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * nlib.hからインクルードされる、HORIZON環境用定義
 */

#ifndef NN_NET_COMPATIBLE_NLIB_NLIB_HORIZON_H_
#define NN_NET_COMPATIBLE_NLIB_NLIB_HORIZON_H_

#include <string.h>
#include <stdio.h>
#include <nn/net/osl/osl_Printf.h>
#include <nn/net/osl/osl_String.h>

#ifdef  __cplusplus
extern "C" {
#endif

/*
    以下の関数を用意してください。
    ・NLIB_memcpy
    ・NLIB_memcmp
    ・NLIB_memmove
    ・NLIB_memset
    ・NLIB_strcmp
    ・NLIB_strncmp
    ・NLIB_strlcmp
    ・NLIB_strlen
    ・NLIB_strcat
    ・NLIB_strlcat
    ・NLIB_strcpy
    ・NLIB_strlcpy
    ・NLIB_strchr
    ・NLIB_strrchr
    ・NLIB_strstr
    ・NLIB_strnlen
    ・NLIB_snprintf
    ・NLIB_strtok_r
*/

// TORIAEZU: nnnstdMemCpy から memcpy に変更
#define NLIB_memcpy          memcpy
#define NLIB_memcmp          memcmp
// TORIAEZU: nnnstdMemMove から memmove に変更
#define NLIB_memmove         memmove
#define NLIB_memset          memset
#define NLIB_strcmp          strcmp
#define NLIB_strncmp         strncmp
#define NLIB_strlcmp         strlcmp
#define NLIB_strlen          strlen
#define NLIB_strcat          strcat
#define NLIB_strlcat         strlca
#define NLIB_strcpy          strcpy
#define NLIB_strlcpy         nnnetOslStrlCpy
#define NLIB_strchr          strchr
#define NLIB_strrchr         strrchr
#define NLIB_strstr          strstr

int NLIB_strnlen(const char *str, int len);

#define NLIB_sprintf         nnnetOslTSPrintf
#define NLIB_snprintf        nnnetOslTSNPrintf
char *NLIB_strtok_r(char *str, const char *delim, char **last);	/* strtok_r関数はTWLにないので、別途実装しています。 */


#ifdef  __cplusplus
}
#endif

#endif // NN_NET_COMPATIBLE_NLIB_NLIB_HORIZON_H_
