﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      net モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NET_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(net, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NET_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NET_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NET_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NET_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(net, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NET_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NET_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NET_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NET_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(net, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NET_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NET_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NET_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(net, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NET_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(net, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NET_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NET_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NET_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NET_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(net, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NET_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NET_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NET_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(net, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NET_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(net, Trace, 0, format, args)
#define NN_DETAIL_NET_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Trace, 1, format, args)
#define NN_DETAIL_NET_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Trace, 2, format, args)
#define NN_DETAIL_NET_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Trace, 3, format, args)

#define NN_DETAIL_NET_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(net, Info, 0, format, args)
#define NN_DETAIL_NET_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Info, 1, format, args)
#define NN_DETAIL_NET_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Info, 2, format, args)
#define NN_DETAIL_NET_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Info, 3, format, args)

#define NN_DETAIL_NET_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(net, Warn, 0, format, args)
#define NN_DETAIL_NET_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Warn, 1, format, args)
#define NN_DETAIL_NET_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Warn, 2, format, args)
#define NN_DETAIL_NET_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(net, Warn, 3, format, args)

#define NN_DETAIL_NET_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(net, Error, 0, format, args)
#define NN_DETAIL_NET_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Error, 1, format, args)
#define NN_DETAIL_NET_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Error, 2, format, args)
#define NN_DETAIL_NET_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Error, 3, format, args)

#define NN_DETAIL_NET_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(net, Fatal, 0, format, args)
#define NN_DETAIL_NET_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Fatal, 1, format, args)
#define NN_DETAIL_NET_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Fatal, 2, format, args)
#define NN_DETAIL_NET_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(net, Fatal, 3, format, args)

#define NN_DETAIL_NET_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(net, Trace, 0, text, length)
#define NN_DETAIL_NET_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Trace, 1, text, length)
#define NN_DETAIL_NET_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Trace, 2, text, length)
#define NN_DETAIL_NET_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Trace, 3, text, length)

#define NN_DETAIL_NET_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(net, Info, 0, text, length)
#define NN_DETAIL_NET_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Info, 1, text, length)
#define NN_DETAIL_NET_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Info, 2, text, length)
#define NN_DETAIL_NET_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Info, 3, text, length)

#define NN_DETAIL_NET_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(net, Warn, 0, text, length)
#define NN_DETAIL_NET_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Warn, 1, text, length)
#define NN_DETAIL_NET_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Warn, 2, text, length)
#define NN_DETAIL_NET_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(net, Warn, 3, text, length)

#define NN_DETAIL_NET_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(net, Error, 0, text, length)
#define NN_DETAIL_NET_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Error, 1, text, length)
#define NN_DETAIL_NET_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Error, 2, text, length)
#define NN_DETAIL_NET_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Error, 3, text, length)

#define NN_DETAIL_NET_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(net, Fatal, 0, text, length)
#define NN_DETAIL_NET_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Fatal, 1, text, length)
#define NN_DETAIL_NET_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Fatal, 2, text, length)
#define NN_DETAIL_NET_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(net, Fatal, 3, text, length)
