﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_AutoBuffer.h>
#include <nn/ncm/ncm_PackageInstallTaskBase.h>
#include <nn/kvdb/kvdb_BoundedString.h>

namespace nn { namespace ncm {

    class PackageInstallTask : public PackageInstallTaskBase
    {
    public:
        void Initialize(const char* directoryPath, StorageId storage, void* buffer, size_t bufferSize, bool ignoreTicket = false) NN_NOEXCEPT;

    protected:
        virtual Result PrepareInstallContentMetaData() NN_NOEXCEPT NN_OVERRIDE;
        bool IsContentMetaContentName(const char* name) NN_NOEXCEPT;

    private:
        virtual Result GetInstallContentMetaInfo(ncm::InstallContentMetaInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT NN_OVERRIDE;

        MemoryInstallTaskData m_Data;
    };
}}
