﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/fs_Directory.h>
#include <nn/ncm/ncm_AutoBuffer.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/ncm/ncm_PackageInstallTask.h>
#include <nn/ncm/ncm_SubmissionPackageInstallTask.h>

namespace nn { namespace ncm {

    class HostPackageInstallTask : public SubmissionPackageInstallTask
    {
    public:
        HostPackageInstallTask() NN_NOEXCEPT {}

    private:
        virtual Result PrepareInstallContentMetaData() NN_NOEXCEPT NN_OVERRIDE;
        Result FindContentMeta(ContentId contentId, fs::DirectoryEntry* entry) NN_NOEXCEPT;
    };
}}
