﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <functional>
#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentStorage.h>

namespace nn { namespace ncm {
    class ContentManagerAccessor
    {
    public:
        ContentManagerAccessor(ContentMetaDatabase* db, ContentStorage* storage) NN_NOEXCEPT : m_Db(db), m_Storage(storage) {}

        Result DeleteRedundantAll(const ncm::ContentMetaKey& latest) NN_NOEXCEPT;

        Result DeleteAll(Bit64 contentMetaId) NN_NOEXCEPT;

        Result DeleteRedundant(const ncm::ContentMetaKey& redundant, const ncm::ContentMetaKey* latest) NN_NOEXCEPT;

    private:
        ContentMetaDatabase* m_Db;
        ContentStorage* m_Storage;

        typedef std::function<bool(const ContentMetaKey& key)> KeyDeletePredicate;
        typedef std::function<bool(const ContentId& id)> ContentDeletePredicate;

        Result CleanupRedundantImpl(KeyDeletePredicate KeyDeletePredicate, ContentDeletePredicate ContentDeletePredicate) NN_NOEXCEPT;
        Result CleanupRedundantImplOne(ContentDeletePredicate ContentDeletePredicate, const ContentMetaKey& key) NN_NOEXCEPT;
    };

    class ContentMetaDatabaseBuilder
    {
    public:
        explicit ContentMetaDatabaseBuilder(ContentMetaDatabase* db) NN_NOEXCEPT : m_Db(db) {}

        Result BuildFromPackage(const char* packageRoot) NN_NOEXCEPT;

        Result Cleanup() NN_NOEXCEPT;

    private:
        Result BuildFromPackageContentMeta(void* buffer, size_t size, const ContentInfo& metaInfo) NN_NOEXCEPT;

        ContentMetaDatabase* m_Db;
    };

    Result ListApplicationFromPackage(int* outCount, ApplicationId* outList, int numList, const char* packageRoot) NN_NOEXCEPT;
}}
