﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>

namespace nn { namespace ncm {
    enum ApplyDeltaProgressState : Bit8
    {
        ApplyDeltaProgressState_NotPrepared,
        ApplyDeltaProgressState_Prepared,
        ApplyDeltaProgressState_Applying,
        ApplyDeltaProgressState_DeltaApplied,
        ApplyDeltaProgressState_Commited,
        ApplyDeltaProgressState_Suspended,
        ApplyDeltaProgressState_Fatal,
    };

    struct ApplyDeltaProgress
    {
        int64_t appliedDeltaSize;
        int64_t totalDeltaSize;
        ApplyDeltaProgressState state;
        Bit8 reserved[7];
    };
}}
