﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/lr/lr_Service.h>
#include <nn/lr/lr_ILocationResolver.h>

#include <nn/util/util_Optional.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace lr {

    enum class RedirectionFlag
    {
        None                    = 0,
        Application             = 1 << 0,
    };

    class Redirection;

    class LocationRedirector
    {
        NN_DISALLOW_COPY(LocationRedirector);
        NN_DISALLOW_MOVE(LocationRedirector);

    public:
        LocationRedirector() NN_NOEXCEPT{}
        ~LocationRedirector() NN_NOEXCEPT;

        bool FindRedirection(Path* outValue, ncm::ProgramId id) NN_NOEXCEPT;
        void SetRedirection(ncm::ProgramId id, const Path& path, int flag = 0) NN_NOEXCEPT;
        void ClearRedirection(int flag = 0) NN_NOEXCEPT;
        void SetRedirectionFlag(ncm::ProgramId id, int flag) NN_NOEXCEPT;
        void EraseRedirection(ncm::ProgramId id) NN_NOEXCEPT;

    private:
        util::IntrusiveList<Redirection, util::IntrusiveListBaseNodeTraits<Redirection>> m_RedirectionList;
    };

}}
