﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ホスト・ターゲット通信内部用 API の宣言
 * @detail  外部モジュールでは使用しない、内部用 API の宣言です。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace htclow { namespace detail {

class IUserServiceObject;

/**
 * @brief   サービスオブジェクトを指定して通常用 API を初期化
 *
 * @pre     通常用 API の初期化を実行していない
 * @details サービスオブジェクトを指定して通常用 API の初期化を行います。
 */
void InitializeForUserApiWith(nn::sf::SharedPointer<IUserServiceObject>&& manager) NN_NOEXCEPT;

}}}
