﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fsa/fs_IFileSystem.h>

#include <nn/fs/detail/fs_Newable.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fs_File.h>

namespace nn { namespace fs {
class IStorage;
}}

namespace nn { namespace fssystem {

/**
    @brief IStorage を IFile にするアダプタです。
*/
class StorageFile : public fs::fsa::IFile, public nn::fs::detail::Newable
{
    NN_DISALLOW_COPY(StorageFile);

private:
    fs::IStorage* m_pBaseStorage;
    fs::OpenMode m_Mode;

public:
    StorageFile(nn::fs::IStorage* pBaseStorage, nn::fs::OpenMode mode) NN_NOEXCEPT;

private:
    virtual Result DoRead(size_t* outValue, int64_t offset, void* buffer, size_t size, const fs::ReadOption& option) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoWrite(int64_t offset, const void* buffer, size_t size, const fs::WriteOption& option) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoFlush() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoSetSize(int64_t size) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoGetSize(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DoOperateRange(
        void* outBuffer,
        size_t outBufferSize,
        fs::OperationId operationId,
        int64_t offset,
        int64_t size,
        const void* inBuffer,
        size_t inBufferSize) NN_NOEXCEPT NN_OVERRIDE;
};


}}
