﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/detail/fs_Newable.h>
#include <nn/fssystem/fs_ISaveDataFileSystemCacheManager.h>

namespace nn { namespace fssystem {

class SaveDataFileSystemCacheManager : public ISaveDataFileSystemCacheManager
{
public:
    SaveDataFileSystemCacheManager() NN_NOEXCEPT;

    virtual ~SaveDataFileSystemCacheManager() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    void Initialize(int maxCacheCount) NN_NOEXCEPT;
    virtual bool GetCache(std::shared_ptr<nn::fssystem::SaveDataFileSystem>* pOutFileSystem, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Register(std::shared_ptr<nn::fssystem::SaveDataFileSystem>&& pFileSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Register(std::shared_ptr<nn::fssystem::ApplicationTemporaryFileSystem>&& pFileSystem) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Unregister(nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id) NN_NOEXCEPT NN_OVERRIDE;

    std::unique_lock<os::Mutex> GetScopedLock() NN_NOEXCEPT
    {
        return std::unique_lock<os::Mutex>(m_Mutex);
    }

private:
    class Cache : public nn::fs::detail::Newable
    {
    public:
        void Register(std::shared_ptr<nn::fssystem::SaveDataFileSystem>&& pFileSystem) NN_NOEXCEPT;
        bool IsCached(nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId id) const NN_NOEXCEPT;
        std::shared_ptr<nn::fssystem::SaveDataFileSystem> Move() NN_NOEXCEPT;
        void Unregister() NN_NOEXCEPT;

    private:
        std::shared_ptr<nn::fssystem::SaveDataFileSystem> m_pSaveDataFileSystem;
        nn::fs::SaveDataId m_CachedId;
        nn::fs::SaveDataSpaceId m_CachedSpaceId;
    };

private:
    nn::os::Mutex m_Mutex;
    std::unique_ptr<Cache[]> m_pCachedFileSystems;
    int m_MaxCachedFileSystemCount;
    int m_NextCacheIndex;
};

}}
