﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_Types.h>

namespace nn { namespace fssystem {

#include <nn/fs/fs_Result.private.h>

// パス長
static const size_t MAX_DIRNAME_CHAR_LEN = 16;
static const size_t MAX_FILENAME_CHAR_LEN = 16;
static const size_t MAX_ID_LEN = 8;

// ROM パス用文字列型
typedef char RomPathChar;

// ファイル情報
struct FileOptionalInfo
{
    Bit8 info[4];
};
NN_STATIC_ASSERT(std::is_pod<FileOptionalInfo>::value);

//!< ROM ファイル情報
struct RomFileOptionalInfo
{
    Bit8 info[4];
};
NN_STATIC_ASSERT(std::is_pod<RomFileOptionalInfo>::value);

//!< ROM 上でのファイル ID
typedef int32_t RomFileId;

// ROM 上でのディレクトリ ID
typedef int32_t RomDirectoryId;

// ディレクトリ付加情報
struct DirectoryInfo
{
    Bit8 info[4];
};
NN_STATIC_ASSERT(std::is_pod<DirectoryInfo>::value);

// ファイル情報
struct FileSystemInfo
{
    uint32_t index;         // Allocation Table での先頭インデックス
    fs::Int64 size;
};
NN_STATIC_ASSERT(std::is_pod<FileSystemInfo>::value);

// ファイル付加情報
struct FileInfo
{
    FileSystemInfo  fs;
    FileOptionalInfo  fo;
};
NN_STATIC_ASSERT(std::is_pod<FileInfo>::value);

//!< ROM ファイルシステム用ディレクトリ付加情報
struct RomDirectoryInfo
{
    //Bit8 info[4];
};
NN_STATIC_ASSERT(std::is_pod<RomDirectoryInfo>::value);

// ROM ファイルシステム用ファイル付加情報
struct RomFileInfo
{
    fs::Int64 offset;                    // ファイルの配置位置
    fs::Int64 size;                      // ファイルのサイズ
    //RomFileOptionalInfo  fo;
};
NN_STATIC_ASSERT(std::is_pod<RomFileInfo>::value);

// ROM ファイルシステムのヘッダ
struct RomFileSystemInformation
{
    int64_t size;                      // ROM ファイルシステムヘッダのサイズ
    int64_t offsetBucketDirectory;     // ディレクトリバケットデータへのオフセット
    int64_t sizeBucketDirectory;       // ディレクトリバケットデータのサイズ
    int64_t offsetDirectoryEntry;      // ディレクトリエントリーデータへのオフセット
    int64_t sizeDirectoryEntry;        // ディレクトリエントリーデータのサイズ
    int64_t offsetBucketFile;          // ファイルバケットデータへのオフセット
    int64_t sizeBucketFile;            // ファイルバケットデータのサイズ
    int64_t offsetFileEntry;           // ファイルエントリーデータへのオフセット
    int64_t sizeFileEntry;             // ファイルエントリーデータのサイズ
    int64_t offsetFileBody;            // ファイル実データへのオフセット
};
NN_STATIC_ASSERT(std::is_pod<RomFileSystemInformation>::value);

namespace StringTraitsRom
{
    // パス区切り文字
    static const RomPathChar DIR_SEPARATOR = '/';

    // 終端文字
    static const RomPathChar NUL = '\0';
}

}}

