﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/fs/detail/fs_IFileSystemPointer.h>
#include <nn/fs/fs_FileSystemForDebug.h>
#include <nn/fssrv/sf/fssrv_IDirectory.h>
#include <nn/fssrv/sf/fssrv_IFile.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace fssrv { namespace sf { // NOLINT(whitespace/braces)

class IFileSystem;

struct Path;

struct Path
{
    char str[769];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFileSystem, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFileSystem)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetImpl, (::nn::sf::Out<::nn::fs::detail::IFileSystemPointer> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateFile, (const ::nn::fssrv::sf::Path& path, ::std::int64_t size, ::std::uint32_t option))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFile, (const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateDirectory, (const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectory, (const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RenameFile, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RenameDirectory, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEntryType, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenDirectory, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDirectory>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CleanDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFileTimeStampRaw, (::nn::sf::Out<::nn::fs::FileTimeStampRaw> outTimeStamp, const ::nn::fssrv::sf::Path& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryEntry, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer, ::std::int32_t queryId, const ::nn::fssrv::sf::Path& path))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFileSystem)

        ::nn::Result GetImpl(::nn::sf::Out<::nn::fs::detail::IFileSystemPointer> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetImpl, (outValue));
        }

        ::nn::Result CreateFile(const ::nn::fssrv::sf::Path& path, ::std::int64_t size, ::std::uint32_t option) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateFile, (path, size, option));
        }

        ::nn::Result DeleteFile(const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteFile, (path));
        }

        ::nn::Result CreateDirectory(const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateDirectory, (path));
        }

        ::nn::Result DeleteDirectory(const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteDirectory, (path));
        }

        ::nn::Result DeleteDirectoryRecursively(const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteDirectoryRecursively, (path));
        }

        ::nn::Result RenameFile(const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RenameFile, (currentPath, newPath));
        }

        ::nn::Result RenameDirectory(const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RenameDirectory, (currentPath, newPath));
        }

        ::nn::Result GetEntryType(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEntryType, (outValue, path));
        }

        ::nn::Result OpenFile(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenFile, (outValue, path, mode));
        }

        ::nn::Result OpenDirectory(::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDirectory>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenDirectory, (outValue, path, mode));
        }

        ::nn::Result Commit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Commit);
        }

        ::nn::Result GetFreeSpaceSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (outValue, path));
        }

        ::nn::Result GetTotalSpaceSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (outValue, path));
        }

        ::nn::Result CleanDirectoryRecursively(const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CleanDirectoryRecursively, (path));
        }

        ::nn::Result GetFileTimeStampRaw(::nn::sf::Out<::nn::fs::FileTimeStampRaw> outTimeStamp, const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFileTimeStampRaw, (outTimeStamp, path));
        }

        ::nn::Result QueryEntry(const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer, ::std::int32_t queryId, const ::nn::fssrv::sf::Path& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryEntry, (outBuffer, inBuffer, queryId, path));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFileSystem
    {
    public:
        nn::Result GetImpl(nn::sf::Out<nn::fs::detail::IFileSystemPointer> outValue) NN_NOEXCEPT;
        nn::Result CreateFile(const nn::fssrv::sf::Path& path, std::int64_t size, std::uint32_t option) NN_NOEXCEPT;
        nn::Result DeleteFile(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result CreateDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result DeleteDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result DeleteDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result RenameFile(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT;
        nn::Result RenameDirectory(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT;
        nn::Result GetEntryType(nn::sf::Out<std::uint32_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDirectory>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT;
        nn::Result Commit() NN_NOEXCEPT;
        nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result CleanDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result GetFileTimeStampRaw(nn::sf::Out<nn::fs::FileTimeStampRaw> outTimeStamp, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
        nn::Result QueryEntry(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer, std::int32_t queryId, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetImpl(nn::sf::Out<nn::fs::detail::IFileSystemPointer> outValue) NN_NOEXCEPT;
    nn::Result CreateFile(const nn::fssrv::sf::Path& path, std::int64_t size, std::uint32_t option) NN_NOEXCEPT;
    nn::Result DeleteFile(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result CreateDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result DeleteDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result DeleteDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result RenameFile(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT;
    nn::Result RenameDirectory(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT;
    nn::Result GetEntryType(nn::sf::Out<std::uint32_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDirectory>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result Commit() NN_NOEXCEPT;
    nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result CleanDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result GetFileTimeStampRaw(nn::sf::Out<nn::fs::FileTimeStampRaw> outTimeStamp, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
    nn::Result QueryEntry(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer, std::int32_t queryId, const nn::fssrv::sf::Path& path) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::fssrv::sf::IFileSystem))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImpl, (::nn::sf::Out<::nn::fs::detail::IFileSystemPointer> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetImpl, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateFile, (const ::nn::fssrv::sf::Path& path, ::std::int64_t size, ::std::uint32_t option))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateFile, (path, size, option));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFile, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteFile, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateDirectory, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateDirectory, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectory, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteDirectory, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteDirectoryRecursively, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RenameFile, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RenameFile, (currentPath, newPath));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RenameDirectory, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RenameDirectory, (currentPath, newPath));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEntryType, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEntryType, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenFile, (outValue, path, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDirectory, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDirectory>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenDirectory, (outValue, path, mode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Commit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeSpaceSize, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTotalSpaceSize, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CleanDirectoryRecursively, (path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFileTimeStampRaw, (::nn::sf::Out<::nn::fs::FileTimeStampRaw> outTimeStamp, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFileTimeStampRaw, (outTimeStamp, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryEntry, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer, ::std::int32_t queryId, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryEntry, (outBuffer, inBuffer, queryId, path));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::fssrv::sf::IFileSystem>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::fssrv::sf::IFileSystem))

    // nn::Result GetImpl(nn::sf::Out<nn::fs::detail::IFileSystemPointer> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::fs::detail::IFileSystemPointer), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetImpl)

    // nn::Result CreateFile(const nn::fssrv::sf::Path& path, std::int64_t size, std::uint32_t option) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(option, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (option, size))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(option)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateFile)

    // nn::Result DeleteFile(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteFile)

    // nn::Result CreateDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateDirectory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateDirectory)

    // nn::Result DeleteDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteDirectory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteDirectory)

    // nn::Result DeleteDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteDirectoryRecursively)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteDirectoryRecursively)

    // nn::Result RenameFile(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RenameFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(currentPath, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(newPath, 1, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (currentPath, newPath))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentPath), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newPath)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RenameFile)

    // nn::Result RenameDirectory(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RenameDirectory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(currentPath, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(newPath, 1, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (currentPath, newPath))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(currentPath), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newPath)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RenameDirectory)

    // nn::Result GetEntryType(nn::sf::Out<std::uint32_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEntryType)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEntryType)

    // nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenFile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenFile)

    // nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDirectory>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenDirectory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (mode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenDirectory)

    // nn::Result Commit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Commit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Commit)

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeSpaceSize)

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTotalSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTotalSpaceSize)

    // nn::Result CleanDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanDirectoryRecursively)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanDirectoryRecursively)

    // nn::Result GetFileTimeStampRaw(nn::sf::Out<nn::fs::FileTimeStampRaw> outTimeStamp, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFileTimeStampRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTimeStamp, (::nn::fs::FileTimeStampRaw), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outTimeStamp))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTimeStamp), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFileTimeStampRaw)

    // nn::Result QueryEntry(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer, std::int32_t queryId, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::fssrv::sf::Path&), 769, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inBuffer, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_NON_SECURE)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (path, outBuffer, inBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(queryId, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (queryId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(queryId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryEntry)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::FileTimeStampRaw), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::fssrv::sf::IFileSystem, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::fssrv::sf::IFileSystem))

    // nn::Result GetImpl(nn::sf::Out<nn::fs::detail::IFileSystemPointer> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetImpl, (::nn::sf::Out<::nn::fs::detail::IFileSystemPointer> outValue))
    {
        NN_UNUSED(outValue);
        NN_SF_CMIF_CLIENT_DETAIL_PROXY_DEFINE_SYNC_METHOD_UNSUPPORTED
    }

    // nn::Result CreateFile(const nn::fssrv::sf::Path& path, std::int64_t size, std::uint32_t option) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateFile, (const ::nn::fssrv::sf::Path& path, ::std::int64_t size, ::std::uint32_t option))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(option)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateFile)
    }

    // nn::Result DeleteFile(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFile, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteFile)
    }

    // nn::Result CreateDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateDirectory, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateDirectory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateDirectory)
    }

    // nn::Result DeleteDirectory(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectory, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteDirectory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteDirectory)
    }

    // nn::Result DeleteDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteDirectoryRecursively)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteDirectoryRecursively)
    }

    // nn::Result RenameFile(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RenameFile, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RenameFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newPath)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RenameFile)
    }

    // nn::Result RenameDirectory(const nn::fssrv::sf::Path& currentPath, const nn::fssrv::sf::Path& newPath) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RenameDirectory, (const ::nn::fssrv::sf::Path& currentPath, const ::nn::fssrv::sf::Path& newPath))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RenameDirectory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(currentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newPath)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RenameDirectory)
    }

    // nn::Result GetEntryType(nn::sf::Out<std::uint32_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEntryType, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEntryType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEntryType)
    }

    // nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenFile, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenFile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenFile)
    }

    // nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDirectory>> outValue, const nn::fssrv::sf::Path& path, std::uint32_t mode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenDirectory, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::fssrv::sf::IDirectory>> outValue, const ::nn::fssrv::sf::Path& path, ::std::uint32_t mode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenDirectory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenDirectory)
    }

    // nn::Result Commit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Commit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Commit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Commit)
    }

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeSpaceSize)
    }

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outValue, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTotalSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTotalSpaceSize)
    }

    // nn::Result CleanDirectoryRecursively(const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanDirectoryRecursively, (const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanDirectoryRecursively)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanDirectoryRecursively)
    }

    // nn::Result GetFileTimeStampRaw(nn::sf::Out<nn::fs::FileTimeStampRaw> outTimeStamp, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFileTimeStampRaw, (::nn::sf::Out<::nn::fs::FileTimeStampRaw> outTimeStamp, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFileTimeStampRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTimeStamp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFileTimeStampRaw)
    }

    // nn::Result QueryEntry(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer, std::int32_t queryId, const nn::fssrv::sf::Path& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryEntry, (const ::nn::sf::OutBuffer& outBuffer, const ::nn::sf::InBuffer& inBuffer, ::std::int32_t queryId, const ::nn::fssrv::sf::Path& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(queryId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryEntry)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::fssrv::sf::IFileSystem>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::fssrv::sf::IFileSystem))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(option)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateDirectory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteDirectory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteDirectoryRecursively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteDirectoryRecursively)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RenameFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(currentPath)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(newPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RenameFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(currentPath),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(newPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RenameDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(currentPath)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(newPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RenameDirectory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(currentPath),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(newPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEntryType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEntryType)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IFile>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenFile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::fssrv::sf::IDirectory>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenDirectory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTotalSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanDirectoryRecursively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanDirectoryRecursively)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFileTimeStampRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFileTimeStampRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTimeStamp),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(queryId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteDirectoryRecursively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RenameFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RenameDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEntryType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenFile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenDirectory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Commit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanDirectoryRecursively)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFileTimeStampRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryEntry)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::fssrv::sf::IFileSystem))
