﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/detail/fs_PriorityUtility.h>
#include <nn/fssrv/fssrv_FileSystemProxyServerSessionResourceManager.h>
#include <nn/fssystem/fs_ThreadPriorityChanger.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_HipcServerSessionManagerHandler.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace fssrv {

class RequestHook;

class RequestHookContext
{
    friend class RequestHook;

private:
    util::optional<fssystem::ScopedThreadPriorityChangerByAccessPriority> m_PriorityChanger;
    fs::PriorityRaw m_OldPriority;
    fs::detail::TlsIoValueForInheritance m_OldInlineContext;
};

class RequestHook : public nn::sf::IHipcServerSessionManagerHandler
{
    NN_DISALLOW_COPY(RequestHook);
    NN_DISALLOW_MOVE(RequestHook);

public:
    explicit RequestHook(FileSystemProxyServerSessionResourceManager* pSessionResourceManager) NN_NOEXCEPT
        : m_pSessionResourceManager(pSessionResourceManager)
    {
        NN_SDK_REQUIRES_NOT_NULL(pSessionResourceManager);
    }

    virtual ~RequestHook() NN_NOEXCEPT
    {
    }

public:
    virtual Result BeforeInvoke() NN_NOEXCEPT NN_OVERRIDE;
    virtual void AfterInvoke() NN_NOEXCEPT NN_OVERRIDE;

private:
    FileSystemProxyServerSessionResourceManager* m_pSessionResourceManager;
};

}}

