﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace fssrv { namespace fscreator {

    class MemoryStorageCreator : public IMemoryStorageCreator
    {
        NN_DISALLOW_COPY(MemoryStorageCreator);
        NN_DISALLOW_MOVE(MemoryStorageCreator);

    private:
        struct Buffer
        {
            char*  buffer;
            size_t bufferSize;
            bool   isAllocated;

        public:
            Buffer()
                : buffer(nullptr)
                , bufferSize(0)
                , isAllocated(false)
            {
            }
        };

    public:
        MemoryStorageCreator() NN_NOEXCEPT;
        virtual Result Create(std::shared_ptr<fs::IStorage>* outStorage, char** outRawBuffer, MemoryStorageId id) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result RegisterMemory(MemoryStorageId id, char* buffer, size_t bufferSize) NN_NOEXCEPT NN_OVERRIDE;
        virtual ~MemoryStorageCreator() NN_NOEXCEPT NN_OVERRIDE;

    private:
        nn::os::Mutex m_BufferArrayMutex;
        Buffer m_BufferArray[static_cast<int>(MemoryStorageId::Count)];
    };

}}}
