﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/nn_Allocator.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/fs_ErrorInfoPrivate.h>
#include <nn/fssrv/detail/fssrv_BisPartitionRootPathForHost.h>

namespace nn { namespace fssrv { namespace fscreator {

    class BuiltInStorageFileSystemCreatorHostFs : public IBuiltInStorageFileSystemCreator
    {
        NN_DISALLOW_COPY(BuiltInStorageFileSystemCreatorHostFs);
        NN_DISALLOW_MOVE(BuiltInStorageFileSystemCreatorHostFs);

    public:
        BuiltInStorageFileSystemCreatorHostFs(
            IHostFileSystemCreator* pHostFsCreator
        )
            : m_pHostFsCreator(pHostFsCreator)
        {
        }

        virtual Result Create(std::shared_ptr<fs::fsa::IFileSystem>* pOutFileSystem, const char* rootPath, nn::fs::BisPartitionId id) NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsSignedSystemPartitionOnSdCardValid() NN_NOEXCEPT NN_OVERRIDE;
        virtual void SetSdCardPortReady() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Initialize(fs::FileSystemProxyErrorInfo* pErrorInfo, os::Mutex* pErrorInfoMutex) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result SetBisRoot(nn::fs::BisPartitionId id, const char* rootPath) NN_NOEXCEPT NN_OVERRIDE;

    private:
        IHostFileSystemCreator* const m_pHostFsCreator;
        detail::BisPartitionRootPathForHost m_BisRootPath;
    };

}}}
