﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn {


namespace fs {
    class IStorage;
}

namespace fssystem {
    struct Hash;
    typedef Hash NcaDigest;
}

namespace fssrv { namespace detail {

    class IFileSystemProxyForAdapter : public nn::sf::ISharedObject
    {
    public:
        virtual nn::Result TryAcquireSaveDataEntryOpenCountSemaphore(std::unique_lock<fssystem::SemaphoreAdaptor>* pOutValue) NN_NOEXCEPT = 0;
        virtual nn::Result OpenDataStorageCore(std::shared_ptr<fs::IStorage>* outValue, fssystem::NcaDigest* pOutDigest, nn::Bit64 programIdValue, nn::ncm::StorageId storageId) NN_NOEXCEPT = 0;
        virtual bool IsAccessFailureDetectionObserved() NN_NOEXCEPT = 0;
        virtual void IncrementRomFsRemountForDataCorruptionCount() NN_NOEXCEPT = 0;
        virtual void IncrementRomFsUnrecoverableDataCorruptionByRemountCount() NN_NOEXCEPT = 0;
        virtual void IncrementRomFsRecoveredByInvalidateCacheCount() NN_NOEXCEPT = 0;

    };

}}

}
