﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace fs {

struct Int64
{
    uint32_t low;
    uint32_t high;

    void Set(int64_t s) NN_NOEXCEPT
    {
        this->low = static_cast<uint32_t>(s & static_cast<uint32_t>(0xFFFFFFFF));
        this->high = static_cast<uint32_t>((s & static_cast<uint64_t>(0xFFFFFFFF00000000)) >> 32);
    }

    int64_t Get() const NN_NOEXCEPT
    {
        return (static_cast<int64_t>(this->high) << 32) | static_cast<int64_t>(this->low);
    }

    Int64& operator = (int64_t rhs) NN_NOEXCEPT
    {
        Set(rhs);
        return *this;
    }

    NN_IMPLICIT operator int64_t() const NN_NOEXCEPT
    {
        return Get();
    }
};
NN_STATIC_ASSERT(std::is_pod<Int64>::value);

}}
