﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  FS ライブラリのデバッグ機能のプライベート API の宣言
*/

#pragma once

#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace fs {

//--------------------------------------------------------------------------
/**
*   @brief      Built-In-Storage FS のユーザーパーティション上にパディングファイルを作成します。
*
*   @param[in]  paddingSize     パディングファイルのサイズ
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess              成功しました。
*   @retval     ResultUsableSpaceNotEnough 空き容量が不足しています。
*
*   @details    メタデータによる容量占有も発生するため、空き容量は paddingSize 以上に減少する場合があります。
*/
Result CreatePaddingFile(int64_t paddingSize) NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      Built-In-Storage FS のユーザーパーティション上のパディングファイルを全て削除します。
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess              成功しました。
*
*   @details    CreatePaddingFile() で作成したパディングファイルを全て削除します。
*/
Result DeleteAllPaddingFiles() NN_NOEXCEPT;




Result OverrideSaveDataTransferTokenSignVerificationKey(const void* pBuffer, size_t bufferSize) NN_NOEXCEPT;


//--------------------------------------------------------------------------
/**
*   @brief      HOST から起動されたアプリケーションが MountRom で NAND 上にあるデータをマウントできるように設定します。
*
*   @param[in]  storageId       nn::ncm::StorageId::None および nn::ncm::StorageId::BuiltInUser のみ指定可能です。
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultInvalidArgument       許可されていない storageId が指定されました。
*
*   @details    HOST から起動されたアプリケーションが MountRom を行った場合に限り、本 API で指定されたストレージ上のデータがマウントされます。
*               nn::ncm::StorageId::None を指定した場合は、アプリケーションと同じストレージ上からマウントを行う設定になります。
*/
Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT;

}}
