﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  アプリケーションデータ関連のファイルシステム API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs {

//! @name アプリケーションデータ関連 API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      アプリケーションパッケージ内部を参照するためのファイルシステムをマウントします。
*
*   @param[in]  name       マウント名
*   @param[in]  path       アプリケーションパッケージのパス
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultPathNotFound          path で表されるアプリケーションパッケージのパスが有効ではありません。
*
*   @pre
*       - name が @link mount_name 有効なマウント名 @endlink である。
*       - path が @link entry_path 有効なパス @endlink である。
*
*/
Result MountApplicationPackage(const char* name, const char* path) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs
