﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/detail/fs_MemoryManagementPrivate.h>

namespace nn { namespace fs { namespace detail {

    class Newable
    {
    public:
        static void* operator new(size_t size) NN_NOEXCEPT
        {
            return Allocate(size);
        }

        static void operator delete(void* p, size_t size) NN_NOEXCEPT
        {
            Deallocate(p, size);
        }

        static void* operator new[](size_t size) NN_NOEXCEPT
        {
            return Allocate(size);
        }

        static void operator delete[](void* p, size_t size) NN_NOEXCEPT
        {
            // size に渡される値はコンパイラによって異なります。
            //
            // auto ptr = new Object[count]; delete[] ptr; を実行した際に、
            // ・VisualStudio 2015 の cl.exe では、
            //   operator new[] の size に sizeof(Object) * count が渡され、
            //   operator delete[] の size に sizeof(Object) が渡されます。
            // ・clang-for-nx.0.22.2 (64bit) では、
            //   operator new[] の size に sizeof(Object) * count + 8 が渡され、
            //   operator delete[] の size に sizeof(Object) * count + 8 が渡されます。
            //
            // 現状、nn::fs::detail::Deallocate にデフォルトで設定されている
            // デアロケート関数( nn::fs::DefaultDeallocate )は size を無視しており、
            // 挙動には問題ないためこのままとしています。
            // nn::fs::SetAllocator で size を考慮するデアロケート関数を設定した場合は、
            // 環境によっては問題が発生します。
            // その場合は operator new[] で確保したサイズと同じサイズを Deallocate に渡すよう
            // 対策する必要があります。
            Deallocate(p, size);
        }
    };

}}}
