﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VsRegConfig.h"
#include <Windows.h>
#include <clocale>
#include <string>
#include <tchar.h>

std::wstring s2ws(const std::string& str)
{
    int size_needed = MultiByteToWideChar(CP_UTF8, 0, &str[0], (int)str.size(), NULL, 0);
    std::wstring wstrTo(size_needed, 0);
    MultiByteToWideChar(CP_UTF8, 0, &str[0], (int)str.size(), &wstrTo[0], size_needed);
    return wstrTo;
}
void DisplayErrorNo(LONG errorNo)
{
    const int LpBufferSize = 512;
    TCHAR lpBuffer[LpBufferSize];
    DWORD dwRet;

    setlocale(LC_ALL, setlocale(LC_CTYPE, ""));

    dwRet = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        errorNo,
        0,
        lpBuffer,
        sizeof(lpBuffer) / sizeof(lpBuffer[0]),
        NULL);

    if (dwRet > 0) {
        _ftprintf(stderr, TEXT("%s"), lpBuffer);
    }
}
