﻿using Nintendo.Nact.FileSystem;
using System;
using System.Collections.Generic;
using static Nintendo.Nact.Extensions.FormattableStringExtensions;
using static System.FormattableString;

namespace SigloNact.BuiltIns.ToolChain.GccClang
{
    public class GccCommandHelper : IGccClangCommandHelper
    {
        public GccClangToolChainSpecifier ToolChainSpecifier { get; }

        public GccCommandHelper(GccClangToolChainSpecifier toolChainSpecifier)
        {
            this.ToolChainSpecifier = toolChainSpecifier;
        }

        private string ToolChainSubDir
        {
            get
            {
                if (ToolChainSpecifier.IsPic)
                {
                    return "pic";
                }
                else
                {
                    return "nonpic";
                }
            }
        }

        private string ToolChainPrefix
        {
            get
            {
                switch (ToolChainSpecifier.Architecture)
                {
                    case "arm": return "arm-none-eabi";
                    case "ppc": return "powerpc-eabi";
                    case "aarch64": return "aarch64-none-elf";
                    default: throw new InvalidOperationException(Current($"Unknown Architecture specified: {ToolChainSpecifier.Architecture}."));
                }
            }
        }

        public FilePath CcPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-gcc.exe"));
        public FilePath LdPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-g++.exe"));
        public FilePath ArPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-ar.exe"));
        public FilePath RanlibPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-ranlib.exe"));
        public FilePath ObjdumpPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-objdump.exe"));
        public FilePath ObjcopyPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-objcopy.exe"));
        public FilePath StripPath => ToolChainSpecifier.ToolChainRoot.Combine(Invariant($"{ToolChainSubDir}/bin/{ToolChainPrefix}-strip.exe"));

        // ツールチェイン実行時に上書きする環境変数
        public IReadOnlyDictionary<string, string> EnvironmentVariables => new Dictionary<string, string>();

        public IEnumerable<string> GetBugReportFilesFromOutput(IReadOnlyList<string> lines)
        {
            // GCC 用は必要に応じて実装すること
            return Array.Empty<string>();
        }
    }
}
