﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using Nintendo.Nact.Values;
using SigloNact.Build;
using System;
using System.Collections.Generic;
using static System.FormattableString;

namespace SigloNact.BuiltIns.ToolChain.GccClang
{
    [NactFunctionContainer]
    public static class GccClangFunction
    {
        [NactFunction]
        public static IReadOnlyCollection<string> GetGccClangModelOptionsImpl(string toolChainKind, GccClangArchitectureParameters architectureParameters)
        {
            var toolChainKindParsed = Util.ParseEnum<ToolChainKind>(toolChainKind);

            var flags = new List<string>();
            GccClangUtil.AddModelOptions(flags, toolChainKindParsed, architectureParameters);
            return flags;
        }
    }
}
