﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;

namespace SigloNact.BuiltIns.Target
{
    [NactActionFunctionContainer]
    public static class MergeFirmwareDebugSettingsContainer
    {
        [NactActionFunction]
        public static NactActionResult MergeFirmwareDebugSettings(
            INactActionContext context,
            IReadOnlyCollection<FilePath> sourceFiles,
            FilePath destinationFile)
        {
            var bytes = new List<byte>();

            foreach (var sourcePath in sourceFiles)
            {
                bytes.AddRange(File.ReadAllBytes(sourcePath.PathString));
            }

            var totalSize = (uint)(bytes.Count + 4);

            if (totalSize > 512 * 1024)
            {
                throw new Exception(
                    "Firmware debug settings exceeds limit: 512 kB");
            }

            File.WriteAllBytes(
                destinationFile.PathString,
                new List<byte>().Concat(BitConverter.GetBytes(totalSize))
                                .Concat(bytes)
                                .ToArray());

            return NactActionResult.CreateSuccess(
                sourceFiles,
                new[] { destinationFile });
        }
    }
}
