﻿using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Target
{
    [NactFunctionContainer]
    public static class MakeUnusedSdkDllNamesContainer
    {
        private const int SdkDllCountMax = 11;  // subsdk0..9 + sdk

        [NactFunction]
        public static IEnumerable<string> MakeUnusedSdkDllNames(IEnumerable<object> sdkDllPaths)
        {
            var ret = new List<string>();
            for (var i = sdkDllPaths.Count(); i < SdkDllCountMax; i++)
            {
                if (i == 0)
                {
                    ret.Add("sdk");
                }
                else
                {
                    ret.Add(string.Format("subsdk{0}", i - 1));
                }
            }
            return ret;
        }
    }
}
