﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System.Collections.Generic;
using System.IO;
using System.Threading;

namespace SigloNact.BuiltIns.Target
{
    [NactActionFunctionContainer]
    public static class MakeFirmwareArchiveYmlContainer
    {
        [NactActionFunction]
        public static NactActionResult MakeFirmwareArchiveYml(
            INactActionContext context,
            IReadOnlyCollection<FilePath> sourceNspPaths,
            FilePath destinationPath)
        {
            var lines = new List<string>();
            lines.Add("Name: CupTest");
            lines.Add("");
            lines.Add("Attributes:");
            lines.Add("- Name: SYSTEM");
            lines.Add("  Path:");
            foreach (var path in sourceNspPaths)
            {
                lines.Add("  - " + path.PathString);
            }
            lines.Add("");
            File.WriteAllLines(destinationPath.PathString, lines);

            return NactActionResult.CreateSuccess(
                sourceNspPaths,
                new[] { destinationPath });
        }
    }
}
