﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System.Threading;

namespace SigloNact.BuiltIns.Target
{
    [NactActionFunctionContainer]
    public static class CreateApplicationLdScriptContainer
    {
        [NactActionFunction]
        public static NactActionResult CreateApplicationLdScript(
            INactActionContext context,
            FilePath sdkLdScript,
            FilePath applicationLdScript)
        {
            using (System.IO.StreamReader reader = new System.IO.StreamReader(sdkLdScript.PathString))
            {
                using (System.IO.StreamWriter writer = new System.IO.StreamWriter(applicationLdScript.PathString))
                {
                    while (reader.Peek() >= 0)
                    {
                        string line = reader.ReadLine();
                        if (line.CompareTo("        KEEP (*(.init_array*))") == 0)
                        {
                            writer.WriteLine("        KEEP (*(SORT_BY_INIT_PRIORITY(.init_array.*)))");
                            writer.WriteLine("        KEEP (*(.init_array))");
                        }
                        else if (line.CompareTo("        KEEP (*(.fini_array*))") == 0)
                        {
                            writer.WriteLine("        KEEP (*(SORT_BY_INIT_PRIORITY(.fini_array.*)))");
                            writer.WriteLine("        KEEP (*(.fini_array))");
                        }
                        else
                        {
                            writer.WriteLine(line);
                        }
                    }
                }
            }
            return NactActionResult.CreateSuccess(
                new[] { sdkLdScript },
                new[] { applicationLdScript });
        }
    }
}
