﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Authoring
{
    [NactFunctionContainer]
    public static class MakePartitionFsAdfContentContainer
    {
        private class FileEntry
        {
            public FileEntry(string name, long offset, string path)
            {
                this.Type = "file";
                this.Name = NormalizeName(name);
                this.Offset = offset;
                this.Path = path;
            }

            private string NormalizeName(string name)
            {
                return name.Replace('\\', '/');
            }

            [YamlDotNet.Serialization.YamlMember(Alias = "type")]
            public string Type { get; private set; }

            [YamlDotNet.Serialization.YamlMember(Alias = "name")]
            public string Name { get; private set; }

            [YamlDotNet.Serialization.YamlMember(Alias = "offset")]
            public long Offset { get; private set; }

            [YamlDotNet.Serialization.YamlMember(Alias = "path")]
            public string Path { get; private set; }
        }

        private static IEnumerable<FileEntry> ConvertNamePathPairsToEntries(IEnumerable<ValueTuple<string, FilePath>> namePathPairs)
        {
            long offset = 0;
            foreach (var namePathPair in namePathPairs)
            {
                yield return new FileEntry(namePathPair.Item1, offset, namePathPair.Item2.PathString);
                offset += new FileInfo(namePathPair.Item2.PathString).Length;
            }
        }

        [NactFunction]
        public static string MakePartitionFsAdfContent(
            string formatTypeArgument,
            string versionArgument,
            IEnumerable<IEnumerable<object>> namePathPairs)
        {
            var yamlContent = new
            {
                formatType = formatTypeArgument,
                version = versionArgument,
                entries = ConvertNamePathPairsToEntries(namePathPairs.Select(x => ValueTuple.Create((string)x.ElementAt(0), (FilePath)x.ElementAt(1)))).ToArray()
            };

            var sb = new StringBuilder();
            using (var writer = new System.IO.StringWriter(sb))
            {
                var serializer = new YamlDotNet.Serialization.SerializerBuilder()
                    .EmitDefaults()    // デフォルト値(数値 0 なども出力する)
                    .Build();
                serializer.Serialize(writer, yamlContent);
            }
            return sb.ToString();
        }
    }
}
