﻿using Nintendo.Nact.FileSystem;
using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace SigloNact.BuiltIns.Authoring
{
    [NactFunctionContainer]
    public static class GetContentMetaIdFromMetaFileContainer
    {
        [NactFunction]
        public static string GetContentMetaIdFromMetaFile(FilePath path)
        {
            var xml = XDocument.Load(path.PathString);
            var xmlId =
                from pid in xml.Descendants("ProgramId").
                     Concat(xml.Descendants("Id")).
                     Concat(xml.Descendants("PatchId")).
                     Concat(xml.Descendants("ApplicationId"))
                select (string)pid;
            return Enumerable.First(xmlId);
        }
    }
}
