﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace Nintendo.SigloBuild.Settings
{
    public sealed class ToolChains
    {
        public ToolChain Rynda { get; }
        public ToolChain SigloGcc { get; }
        public ToolChain SigloMsys { get; }
        public ToolChain SigloDtc { get; }

        internal ToolChains(Stream stream)
        {
            var doc = XDocument.Load(stream);
            var toolChainsElement = doc.Element("ToolChains");
            var toolChains = GetToolChains(toolChainsElement);

            this.Rynda = GetToolChain(toolChains, "Rynda");
            this.SigloGcc = GetToolChain(toolChains, "SigloGcc");
            this.SigloMsys = GetToolChain(toolChains, "SigloMsys");
            this.SigloDtc = GetToolChain(toolChains, "SigloDtc");
        }

        private static ToolChain[] GetToolChains(XElement toolChainsElement)
        {
            return toolChainsElement.Elements("ToolChain")
                .Select(x => new ToolChain(x))
                .ToArray();
        }

        private static ToolChain GetToolChain(ToolChain[] toolChains, string id)
        {
            return toolChains.FirstOrDefault(x => x.Id == id)
                ?? throw new InvalidBuildSettingsFileException($"ToolChain '{id}' not found.");
        }
    }
}
