﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.MakeVisualStudioProject.Converter;

namespace Nintendo.MakeVisualStudioProject
{
    internal class PlatformElementConverterComposer
    {
        [ImportMany(typeof(IPlatformElementConverter))]
        public IEnumerable<Lazy<IPlatformElementConverter, IPlatformElementConverterMetadata>> Converters { get; private set; }

        public PlatformElementConverterComposer()
        {
            Program.CompositionContainer.ComposeParts(this);
        }

        public IEnumerable<IPlatformElementConverter> EnumerateConverters()
        {
            return EnumerateConverters(metadata => true);
        }

        public IEnumerable<IPlatformElementConverter> EnumerateConverters(Func<IPlatformElementConverterMetadata, bool> predicate)
        {
            foreach (var converter in Converters)
            {
                if (predicate(converter.Metadata))
                {
                    yield return converter.Value;
                }
            }
        }
    }
}
