﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public abstract class OptionConverter
    {
        protected IOptionStringConverter OptionStringConverter { get; set; }
        protected IItemMetadataConverter ItemMetadataConverter { get; set; }

        public IEnumerable<ItemMetadata> ConvertToItemMetadata(IEnumerable<string> ops, out IEnumerable<string> unknowns)
        {
            IEnumerable<string> unknownOptionStrings;
            var optionValues = OptionStringConverter.ConvertToOptionValue(ops, out unknownOptionStrings);

            IEnumerable<OptionValue> unknownOptionValues;
            var metadatas = ItemMetadataConverter.ConvertToItemMetadata(optionValues, out unknownOptionValues);

            unknowns = unknownOptionStrings;
            if (unknownOptionValues.Any())
            {
                throw new NotImplementedException();
            }

            return metadatas;
        }

        public IEnumerable<string> ConvertToOptionString(IEnumerable<ItemMetadata> ims, out IEnumerable<ItemMetadata> unknowns)
        {
            IEnumerable<ItemMetadata> unknownItemMetadatas;
            var optionValues = ItemMetadataConverter.ConvertToOptionValue(ims, out unknownItemMetadatas);

            IEnumerable<OptionValue> unknownOptionValues;
            var optionStrings = OptionStringConverter.ConvertToOptionString(optionValues, out unknownOptionValues);

            unknowns = unknownItemMetadatas;
            if (unknownOptionValues.Any())
            {
                throw new NotImplementedException();
            }

            return optionStrings;
        }
    }
}
