﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    internal static class XmlElementExtension
    {
        public static string GetAttributeOrThrow(this XmlElement e, string name)
        {
            if (e.HasAttribute(name))
            {
                return e.GetAttribute(name);
            }
            else
            {
                throw new ArgumentException(name + "が見つかりません");
            }
        }

        public static string GetAttributeOrNull(this XmlElement e, string name)
        {
            if (e.HasAttribute(name))
            {
                return e.GetAttribute(name);
            }
            else
            {
                // 空文字列が指定されている場合と未定義の場合を区別するため、
                // 未定義の場合は null を返す
                return null;
            }
        }

        public static string GetSwitchAttributeWithPrefix(this XmlElement e, string prefix, string name = "Switch")
        {
            var attribute = GetAttributeOrNull(e, name);
            if (!string.IsNullOrEmpty(attribute))
            {
                return prefix + attribute;
            }
            return attribute;
        }

        public static bool HasAttributeAndStringValue(this XmlElement e, string name)
        {
            return !string.IsNullOrEmpty(e.GetAttribute(name));
        }
    }
}
