﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    internal class NXOptionConverter : OptionConverter
    {
        public static NXOptionConverter GetCompilerOptionConverter(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return new NXOptionConverter(NXOptionDefinitionGenerator.GetCompilerOptionDefinitions(platform, vcToolsVersion, vsVersion));
        }

        public static NXOptionConverter GetLibrarianOptionConverter(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return new NXOptionConverter(NXOptionDefinitionGenerator.GetLibrarianOptionDefinitions(platform, vcToolsVersion, vsVersion));
        }

        public static NXOptionConverter GetLinkerOptionConverter(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return new NXOptionConverter(NXOptionDefinitionGenerator.GetLinkerOptionDefinitions(platform, vcToolsVersion, vsVersion));
        }

        private NXOptionConverter(IEnumerable<OptionDefinition> ods)
        {
            this.OptionStringConverter = new NXOptionStringConverter(ods);
            this.ItemMetadataConverter = new NXItemMetadataConverter(ods);
        }

        private static string CreateBuiltInOptionDefinitionYamlFileResourceName(string toolName, string platform)
        {
            return $"Nintendo.MakeVisualStudioProject.BuiltInOptionDefinition.{toolName}.{platform}.yml";
        }
        public static NXOptionConverter GetBuiltInCompilerOptionConverter(string platform)
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("cl", platform);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException($"VSI for NX のプラットフォーム '{platform}' に対応する clang.exe オプション定義は組み込まれていません。");
                }
                using (var reader = new StreamReader(stream))
                {
                    return new NXOptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
        public static NXOptionConverter GetBuiltInLibrarianOptionConverter(string platform)
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("lib", platform);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException($"VSI for NX のプラットフォーム '{platform}' に対応する ar.exe オプション定義は組み込まれていません。");
                }
                using (var reader = new StreamReader(stream))
                {
                    return new NXOptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
        public static NXOptionConverter GetBuiltInLinkerOptionConverter(string platform)
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("link", platform);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException($"VSI for NX のプラットフォーム '{platform}' に対応する clang++.exe オプション定義は組み込まれていません。");
                }
                using (var reader = new StreamReader(stream))
                {
                    return new NXOptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
    }
}
