﻿using System;
using System.Collections.Generic;
using System.IO;
using Nintendo.MakeVisualStudioProject.Converter;

var generationConfigurations = new (string yamlFileNameWithoutExtension, Func<IEnumerable<OptionDefinition>> optionDefinitionFactory)[]
{
    ("cl.NX32", () => NXOptionDefinitionGenerator.GetCompilerOptionDefinitions("NX32")),
    ("lib.NX32", () => NXOptionDefinitionGenerator.GetLibrarianOptionDefinitions("NX32")),
    ("link.NX32", () => NXOptionDefinitionGenerator.GetLinkerOptionDefinitions("NX32")),
    ("cl.NX64", () => NXOptionDefinitionGenerator.GetCompilerOptionDefinitions("NX64")),
    ("lib.NX64", () => NXOptionDefinitionGenerator.GetLibrarianOptionDefinitions("NX64")),
    ("link.NX64", () => NXOptionDefinitionGenerator.GetLinkerOptionDefinitions("NX64")),
};

foreach (var generationConfiguration in generationConfigurations)
{
    var optionDefinitions = generationConfiguration.optionDefinitionFactory();
    var yamlFileName = generationConfiguration.yamlFileNameWithoutExtension + ".yml";

    using (var writer = new StreamWriter(yamlFileName))
    {
        OptionDefinitionGenerator.SaveDefinitions(writer, optionDefinitions);
    }
}
