﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Target
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkCheckFinalizeMetaSourceExistence : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }
            if (ctx.Intent.BuildEnvironment != Constants.BuildEnvironment.Repository)
            {
                yield break;
            }

            yield return new ProjectTarget("NintendoSdkCheckFinalizeMetaSourceExistence", Constants.Condition.PlatformNX32OrNX64, "ExeFinalize", null,
                new ProjectErrorTask(
                    "nmeta ファイル '%(Link.FinalizeMetaSource)' が見つかりません。正しいパスを指定するか、nact で自動生成してください。",
                    "!exists('%(Link.FinalizeMetaSource)') and '$(LangID)'=='1041'"),
                new ProjectErrorTask(
                    "Could not find nmeta file '%(Link.FinalizeMetaSource)'. Please specify the path correctly or auto-generate it by nact.",
                    "!exists('%(Link.FinalizeMetaSource)') and '$(LangID)'!='1041'"));
        }
    }
}
