﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkLibraryPath : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            // Alice, Chris, Eris, Iris, NintendoWare によってパスが異なるので、手書きの props で設定する
                            break;
                        case Constants.Deliverable.SdkSample:
                        case Constants.Deliverable.SdkTest:
                        case Constants.Deliverable.Application:
                            yield return new ProjectProperty("NintendoSdkLibraryPath", "" +
                                @"$(NintendoSdkRoot)Programs\NintendoWare\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                                @"$(NintendoSdkRoot)Programs\Iris\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                                @"$(NintendoSdkRoot)Programs\Eris\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                                @"$(NintendoSdkRoot)Programs\Chris\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                                @"$(NintendoSdkRoot)Programs\Alice\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                                @"$(NintendoSdkLibraryPath)");
                            break;
                        default:
                            ReportUnexpectedDeliverable(ctx);
                            break;
                    }
                    break;
                case Constants.BuildEnvironment.Package:
                    yield return new ProjectProperty("NintendoSdkLibraryPath", "" +
                        @"$(NintendoSdkRoot)Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                        @"$(NintendoSdkRoot)Libraries\$(NintendoSdkBuildTarget)\Develop;" +
                        @"$(NintendoSdkLibraryPath)",
                        Constants.Condition.NintendoSdkBuildTypeDebug);
                    yield return new ProjectProperty("NintendoSdkLibraryPath", "" +
                        @"$(NintendoSdkRoot)Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType);" +
                        @"$(NintendoSdkLibraryPath)",
                        Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease);
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
