﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkDllSuffix : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectProperty("NintendoSdkDllSuffix", ".dll", Constants.Condition.PlatformWin32OrX64);

            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    // 不要
                    break;
                case Constants.Spec.NX:
                    yield return new ProjectProperty("NintendoSdkDllSuffix", ".nso", Constants.Condition.PlatformNX32OrNX64);
                    break;
                case Constants.Spec.Cafe:
                    yield return new ProjectProperty("NintendoSdkDllSuffix", ".rpl", Constants.Condition.PlatformCafe);
                    break;
                default:
                    ReportUnexpectedSpec(ctx);
                    break;
            }
        }
    }
}
