﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class IncludePath : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    return ConstructWindowsVcIncludePaths(ctx);
                case Constants.Spec.NX:
                    return ConstructWindowsVcIncludePaths(ctx).Concat(ConstructNXIncludePaths(ctx));
                case Constants.Spec.Cafe:
                    return ConstructWindowsVcIncludePaths(ctx).Concat(ConstructCafeIncludePaths(ctx));
                default:
                    ReportUnexpectedSpec(ctx);
                    return Enumerable.Empty<ProjectElement>();
            }
        }

        private IEnumerable<ProjectElement> ConstructWindowsVcIncludePaths(ConstructionContext ctx)
        {
            var includePaths = new List<string>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.SdkSample:
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Outputs\Include");
                    break;
                case Constants.Deliverable.SdkTest:
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\TestFrameworks\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\googletest\googlemock\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\googletest\googletest\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Outputs\Include");
                    break;
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            includePaths.Add("$(NintendoSdkIncludePath)");

            yield return ConstructIncludePathProperty(includePaths, Constants.Condition.PlatformWin32OrX64);
        }

        private IEnumerable<ProjectElement> ConstructNXIncludePaths(ConstructionContext ctx)
        {
            var includePaths = new List<string>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.SdkSample:
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Outputs\Include");
                    break;
                case Constants.Deliverable.SdkTest:
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\TestFrameworks\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\googletest\googlemock\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\googletest\googletest\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Outputs\Include");
                    break;
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            includePaths.Add("$(NintendoSdkIncludePath)");

            yield return ConstructIncludePathProperty(
                includePaths.Concat(new[] { @"$(NXToolchainDir)\nx\armv7l\lib\clang\$(NXToolchainVersion)\include" }), Constants.Condition.PlatformNX32);
            yield return ConstructIncludePathProperty(
                includePaths.Concat(new[] { @"$(NXToolchainDir)\nx\aarch64\lib\clang\$(NXToolchainVersion)\include" }), Constants.Condition.PlatformNX64);
        }

        private IEnumerable<ProjectElement> ConstructCafeIncludePaths(ConstructionContext ctx)
        {
            var includePaths = new List<string>();

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.SdkSample:
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Samples\Outputs\Include");
                    break;
                case Constants.Deliverable.SdkTest:
                    includePaths.Add(@"$(NintendoSdkRoot)Externals\nw4f_externals\Sources\Libraries\googletest\include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Include");
                    includePaths.Add(@"$(NintendoSdkRoot)Tests\Outputs\Include");
                    break;
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }

            includePaths.Add("$(NintendoSdkIncludePath)");

            yield return ConstructIncludePathProperty(includePaths, Constants.Condition.PlatformCafe);
        }

        private ProjectElement ConstructIncludePathProperty(IEnumerable<string> includePaths, string condition)
        {
            return new ProjectProperty("IncludePath", string.Join(";", includePaths.Concat(new[] { "$(IncludePath)" })), condition);
        }
    }
}
