﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor
{
    public abstract class ProjectElementConstructor
    {
        public class ConstructionContext
        {
            public ReleaseIntent Intent { get; }

            public ConstructionContext(ReleaseIntent intent)
            {
                Intent = intent;
            }
        }

        public abstract IEnumerable<ProjectElement> Construct(ConstructionContext ctx);

        protected void ReportUnexpectedBuildEnvironment(ConstructionContext ctx)
        {
            throw new ImplementationErrorException($"unexpected build environment: {ctx.Intent.BuildEnvironment}");
        }

        protected void ReportUnexpectedSpec(ConstructionContext ctx)
        {
            throw new ImplementationErrorException($"unexpected spec: {ctx.Intent.Spec}");
        }

        protected void ReportUnexpectedDeliverable(ConstructionContext ctx)
        {
            throw new ImplementationErrorException($"unexpected deliverable: {ctx.Intent.Deliverable}");
        }
    }
}
