﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class FinalizeDescSource : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            if (ctx.Intent.Deliverable == Constants.Deliverable.SdkTest)
            {
                yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("FinalizeDescSource", @"$(NintendoSdkRoot)Tests\Common\Resources\TestApplication.autogen.desc"));
            }
            else
            {
                yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("FinalizeDescSource", "$(NintendoSdkSpecFilesDirectory)Application.desc"));
            }
        }
    }
}
