﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class ProgramDataBaseFileName : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkTest:
                case Constants.Deliverable.SdkSample:
                    yield return new ProjectItemDefinition("ClCompile",
                        new ProjectMetadata("ProgramDataBaseFileName", "$(OutDir)$(TargetName).pdb"));
                    break;
                case Constants.Deliverable.Application:
                    // 必要？
                    yield return new ProjectItemDefinition("ClCompile", Constants.Condition.ConfigurationTypeLibrary,
                        new ProjectMetadata("ProgramDataBaseFileName", "$(OutDir)$(TargetName).pdb"));
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
