﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    // cl の同等のプロパティは LanguageStandard であることに注意
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class CppLanguageStandard : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseClang}",
                new ProjectMetadata("CppLanguageStandard", "gnu++1y"));
        }
    }
}
