﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Libgit2;

namespace GitExternalStorage.Git
{
    public class GitRepositoryLibgit2 : GitRepositoryBase
    {
        private Repository repository;

        public GitRepositoryLibgit2(string workingDirectory)
        {
            this.repository = new Repository(workingDirectory);
        }

        public override void Init()
        {
            try
            {
                this.repository.Init();
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void Open()
        {
            try
            {
                this.repository.Open();
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override string GetGitDirectory()
        {
            try
            {
                return this.repository.GetGitDirectory();
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override string GetRepositoryRoot()
        {
            try
            {
                return this.repository.GetRootDirectory();
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override bool IsInsideRepository()
        {
            try
            {
                return this.repository.IsInsideRepository();
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override string GetConfig(string name)
        {
            try
            {
                return this.repository.GetConfig(name);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void SetConfig(string name, string value)
        {
            try
            {
                this.repository.SetConfig(name, value);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override IEnumerable<TreeEntry> GetHeadTree()
        {
            try
            {
                return this.repository.GetHeadTree().Select(x => new TreeEntry { FilePath = x.FilePath, FileSize = x.FileSize });
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void Add(string filepath)
        {
            try
            {
                this.repository.Add(filepath);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void Commit(string message)
        {
            throw new NotImplementedException();
        }

        public override string ShowHead(string filepath)
        {
            try
            {
                return this.repository.ShowHead(filepath);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void Checkout(string filepath)
        {
            try
            {
                this.Checkout(new List<string> { filepath });
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void Checkout(List<string> filelist)
        {
            try
            {
                this.repository.Checkout(filelist);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public void Expand(List<string> filelist, string cacheDirectoryPath)
        {
            try
            {
                this.repository.Expand(filelist, cacheDirectoryPath);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }

        public override void SetAssumeUnchanged(List<string> filelist, bool assumeUnchanged)
        {
            try
            {
                this.repository.SetAssumeUnchanged(filelist, assumeUnchanged);
            }
            catch (Exception e)
            {
                throw new GitRepositoryCommandFailedException("git 操作に失敗しました。", e);
            }
        }
    }
}
