﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepositoryManager.Exceptions.Git;
using GitExternalRepositoryManager.Exceptions.Utilities;
using GitExternalRepositoryManager.Utilities;

namespace GitExternalRepositoryManager.Git
{
    public static class GitCommandUtility
    {
        /// <summary>
        /// Git コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        public static string Run(string options)
        {
            try
            {
                return ProcessUtility.Run("git", options).Trim();
            }
            catch (ProcessUtilityExitCodeNonZeroException e)
            {
                throw new GitRepositoryCommandFailedException("Failed to execute git.", e)
                {
                    Data = { { "Detail", string.Format("Failed to execute 'git {0}'.", options) } }
                };
            }
            catch (ProcessUtilityWin32Exception e)
            {
                throw new GitRepositoryCommandNotFoundException("Not found git.", e)
                {
                    Data = { { "Detail", string.Format("Not found 'git {0}'.", options) } }
                };
            }
        }
    }
}
