﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepository.Commands;

namespace GitExternalRepository
{
    public static class Utils
    {
        /// <summary>
        /// 指定の型を継承するクラスを列挙します。
        /// </summary>
        /// <typeparam name="T">型</typeparam>
        /// <returns>クラスの Type</returns>
        public static IEnumerable<Type> GetInheritedClasses<T>()
        {
            return System.Reflection.Assembly.GetAssembly(typeof(T)).GetTypes().Where(x =>
                {
                    /*
                     * 以下の条件をすべて満たすものを列挙します。
                     *
                     *  * クラスである。
                     *  * 抽象型ではない。
                     *  * T にキャスト可能である。
                     *  * T ではない。
                     *
                     */
                    return x.IsClass && !x.IsAbstract && typeof(T).IsAssignableFrom(x) && x != typeof(T);
                });
        }
    }
}
