﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Repository.Git
{
    public static class GitCommandUtils
    {
        static bool Verbose = false;

        /// <summary>
        /// Git コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        /// <returns>コマンドの標準出力結果</returns>
        public static string GetGitOutput(string workingDirectory, string options)
        {
            if (Verbose)
            {
                Environment.SetEnvironmentVariable("GIT_TRACE", "true");
                Environment.SetEnvironmentVariable("GIT_TRACE_SETUP", "true");
            }

            Environment.SetEnvironmentVariable("GIT_WORK_TREE", "");

            try
            {
                return ProcessUtility.GetProcessOutput("git", options, workingDirectory).Trim();
            }
            catch (ProcessUtilityExitCodeNonZeroException e)
            {
                throw new GitRepositoryCommandFailedException("Failed to execute git.", e)
                {
                    Data = { { "Detail", string.Format("Failed to execute 'git {0}'.", options) } }
                };
            }
            catch (ProcessUtilityWin32Exception e)
            {
                throw new GitRepositoryCommandNotFoundException("Not found git.", e)
                {
                    Data = { { "Detail", string.Format("Not found 'git {0}'.", options) } }
                };
            }
        }

        /// <summary>
        /// Git コマンドを実行します。
        /// </summary>
        /// <param name="options">コマンドに与える引数</param>
        public static void RunGit(string workingDirectory, string options)
        {
            if (Verbose)
            {
                Environment.SetEnvironmentVariable("GIT_TRACE", "true");
                Environment.SetEnvironmentVariable("GIT_TRACE_SETUP", "true");
            }

            Environment.SetEnvironmentVariable("GIT_WORK_TREE", "");

            try
            {
                ProcessUtility.RunProcess("git", options, workingDirectory);
            }
            catch (ProcessUtilityExitCodeNonZeroException e)
            {
                throw new GitRepositoryCommandFailedException("Failed to execute git.", e)
                {
                    Data = { { "Detail", string.Format("Failed to execute 'git {0}'.", options) } }
                };
            }
            catch (ProcessUtilityWin32Exception e)
            {
                throw new GitRepositoryCommandNotFoundException("Not found git.", e)
                {
                    Data = { { "Detail", string.Format("Not found 'git {0}'.", options) } }
                };
            }
        }
    }
}
