﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Matrix.h>

namespace nn { namespace util {

const util::MatrixRowMajor3x2fType MatrixRowMajor3x2f::ConstantZero = NN_UTIL_MATRIX_ROW_MAJOR_3X2F_INITIALIZER(
    0.f, 0.f,
    0.f, 0.f,
    0.f, 0.f);

const util::MatrixRowMajor3x2fType MatrixRowMajor3x2f::ConstantIdentity = NN_UTIL_MATRIX_ROW_MAJOR_3X2F_INITIALIZER(
    1.f, 0.f,
    0.f, 1.f,
    0.f, 0.f);

const util::MatrixRowMajor4x3fType MatrixRowMajor4x3f::ConstantZero = NN_UTIL_MATRIX_ROW_MAJOR_4X3F_INITIALIZER(
    0.f, 0.f, 0.f,
    0.f, 0.f, 0.f,
    0.f, 0.f, 0.f,
    0.f, 0.f, 0.f);
const util::MatrixRowMajor4x3fType MatrixRowMajor4x3f::ConstantIdentity = NN_UTIL_MATRIX_ROW_MAJOR_4X3F_INITIALIZER(
    1.f, 0.f, 0.f,
    0.f, 1.f, 0.f,
    0.f, 0.f, 1.f,
    0.f, 0.f, 0.f);

const util::MatrixRowMajor4x4fType MatrixRowMajor4x4f::ConstantZero = NN_UTIL_MATRIX_ROW_MAJOR_4X4F_INITIALIZER(
    0.f, 0.f, 0.f, 0.f,
    0.f, 0.f, 0.f, 0.f,
    0.f, 0.f, 0.f, 0.f,
    0.f, 0.f, 0.f, 0.f);
const util::MatrixRowMajor4x4fType MatrixRowMajor4x4f::ConstantIdentity = NN_UTIL_MATRIX_ROW_MAJOR_4X4F_INITIALIZER(
    1.f, 0.f, 0.f, 0.f,
    0.f, 1.f, 0.f, 0.f,
    0.f, 0.f, 1.f, 0.f,
    0.f, 0.f, 0.f, 1.f);
}}
