﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Color.h>

namespace nn { namespace util {

    const Unorm8x4 Color4u8::ConstantBlack   = { { 0x00, 0x00, 0x00, 0xff } };
    const Unorm8x4 Color4u8::ConstantGray    = { { 0x80, 0x80, 0x80, 0xff } };
    const Unorm8x4 Color4u8::ConstantWhite   = { { 0xff, 0xff, 0xff, 0xff } };
    const Unorm8x4 Color4u8::ConstantRed     = { { 0xff, 0x00, 0x00, 0xff } };
    const Unorm8x4 Color4u8::ConstantGreen   = { { 0x00, 0xff, 0x00, 0xff } };
    const Unorm8x4 Color4u8::ConstantBlue    = { { 0x00, 0x00, 0xff, 0xff } };
    const Unorm8x4 Color4u8::ConstantYellow  = { { 0xff, 0xff, 0x00, 0xff } };
    const Unorm8x4 Color4u8::ConstantMagenta = { { 0xff, 0x00, 0xff, 0xff } };
    const Unorm8x4 Color4u8::ConstantCyan    = { { 0x00, 0xff, 0xff, 0xff } };

    const float Color4u8::SrgbDefault = 1.f / 2.2f;
    const float Color4u8::LinearDefault = 2.2f;

    const Vector4fType Color4f::ConstantBlack   = NN_UTIL_VECTOR_4F_INITIALIZER( 0.0f, 0.0f, 0.0f, 1.0f );
    const Vector4fType Color4f::ConstantGray    = NN_UTIL_VECTOR_4F_INITIALIZER( 0.5f, 0.5f, 0.5f, 1.0f );
    const Vector4fType Color4f::ConstantWhite   = NN_UTIL_VECTOR_4F_INITIALIZER( 1.0f, 1.0f, 1.0f, 1.0f );
    const Vector4fType Color4f::ConstantRed     = NN_UTIL_VECTOR_4F_INITIALIZER( 1.0f, 0.0f, 0.0f, 1.0f );
    const Vector4fType Color4f::ConstantGreen   = NN_UTIL_VECTOR_4F_INITIALIZER( 0.0f, 1.0f, 0.0f, 1.0f );
    const Vector4fType Color4f::ConstantBlue    = NN_UTIL_VECTOR_4F_INITIALIZER( 0.0f, 0.0f, 1.0f, 1.0f );
    const Vector4fType Color4f::ConstantYellow  = NN_UTIL_VECTOR_4F_INITIALIZER( 1.0f, 1.0f, 0.0f, 1.0f );
    const Vector4fType Color4f::ConstantMagenta = NN_UTIL_VECTOR_4F_INITIALIZER( 1.0f, 0.0f, 1.0f, 1.0f );
    const Vector4fType Color4f::ConstantCyan    = NN_UTIL_VECTOR_4F_INITIALIZER( 0.0f, 1.0f, 1.0f, 1.0f );

    const float Color4f::SrgbDefault = 1.f / 2.2f;
    const float Color4f::LinearDefault = 2.2f;
}}
